/*
 * VideoFrame.java
 *
 * Created on 13. Januar 2004, 16:26
 */

/**
 *
 * @author  Arnd
 */
import javax.swing.*;
import javax.media.*;
import javax.media.protocol.*;
import java.io.*;
import javax.media.datasink.*;

public class VideoFrame extends javax.swing.JFrame {



    /** Creates new form VideoFrame */
    public VideoFrame() {
        initComponents();
        initPlayer();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        Toolbar = new javax.swing.JToolBar();
        markStartButton = new javax.swing.JButton();
        startTextField = new javax.swing.JTextField();
        markStopButton = new javax.swing.JButton();
        stopTextField = new javax.swing.JTextField();
        menuSeparator = new javax.swing.JSeparator();
        loopButton = new javax.swing.JToggleButton();
        saveButton = new javax.swing.JButton();

        setTitle("Video Player");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        markStartButton.setText("Start");
        markStartButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                markStartButtonActionPerformed(evt);
            }
        });

        Toolbar.add(markStartButton);

        startTextField.setEditable(false);
        startTextField.setText("0");
        Toolbar.add(startTextField);

        markStopButton.setText("Stop");
        markStopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                markStopButtonActionPerformed(evt);
            }
        });

        Toolbar.add(markStopButton);

        stopTextField.setEditable(false);
        stopTextField.setText("0");
        Toolbar.add(stopTextField);

        menuSeparator.setOrientation(javax.swing.SwingConstants.VERTICAL);
        menuSeparator.setPreferredSize(new java.awt.Dimension(4, 10));
        Toolbar.add(menuSeparator);

        loopButton.setText("loop");
        Toolbar.add(loopButton);

        saveButton.setText("Save .mov");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });

        Toolbar.add(saveButton);

        getContentPane().add(Toolbar, java.awt.BorderLayout.NORTH);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(640, 480));
        setLocation((screenSize.width-640)/2,(screenSize.height-480)/2);
    }//GEN-END:initComponents

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveButtonActionPerformed
        //Methode zum Speichern des Films in RGB, Quicktime aufrufen
        saveQuickTimeMovie();
    }//GEN-LAST:event_saveButtonActionPerformed

    private void markStopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_markStopButtonActionPerformed
        //zu Aufgabe 2:
        //aktuelle Medienzeit vom Player auslesen
        //und in Instanzattribut stopTime speichern
        //sowie im Textfeld stopTextField anzeigen

    }//GEN-LAST:event_markStopButtonActionPerformed

    private void markStartButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_markStartButtonActionPerformed
        //zu Aufgabe 2:
        //aktuelle Medienzeit vom Player auslesen
        //und in Instanzattribut startTime speichern
        //sowie im Textfeld startTextField anzeigen

    }//GEN-LAST:event_markStartButtonActionPerformed


    //Aufgabe 1: Player initialisieren
    private void initPlayer() {
        java.net.URL fileURL = ClassLoader.getSystemResource("./video/source.avi");


        //Datenquelle ds erzeugen mit File-URL

        //Mit Datenquelle startbereiten Player erzeugen

        //visuelle Komponenten (Steuer- und Bildkomponente) des Players in unteren Teil des Frames
        //einfgen

        //ControllerListener zum Player hinzufgen, um relevante Events abzufangen

        //Instanzattribut startTime  (s. Deklaration) mit 0 initialisieren
        this.startTime = new Time(0.0);
        //Wert in startTextField ausgeben
        startTextField.setText(new Double(startTime.getSeconds()).toString());

        //Instanzattribut stopTime (s. Deklaration) mit Dauer des Videoclips initialisieren
        this.stopTime = new Time(player.getDuration().getSeconds());
        //Wert in stopTextField ausgeben
        stopTextField.setText(new Double(stopTime.getSeconds()).toString());
    }

    //Aufgabe 2: Methode, um ControllerEvents vom Player zu behandeln
    private void handleControllerEvent(ControllerEvent e) {

        //Prfen ob StartEvent generiert wurde
        //wenn ja: Falls Loop-Button selektiert, Stoppmarke des Players auf stopTime
        //setzen

        //Prfen ob StopAtTimeEvent generiert wurde
        //wenn ja: Falls Loop-Button selektiert, Player auf startTime setzen und
        //neu starten

    }

    //Aufgabe 3: wird bei Bettigung der "Save .mov"-Taste aufgerufen
    private void saveQuickTimeMovie() {
        //Loop-Button deselektieren--> keine Schleifen spielen
        loopButton.setSelected(false);

        //Datenquelle ds durch klonbare Datenquelle ersetzen

        //Datenquelle klonen

        //ProcessorModel erzeugen mit der geklonten Datenquelle, Ausgangsformat unkomprimiertes RGB, Fileausgangstyp Quicktime;

        //mit ProcessorModel startbereiten Prozessor erzeugen

        //ControllerListener zum Abfangen der Prozessorevents zum Prozessor hinzufgen

        //Ausgangsdatenquelle von Prozessor holen

        java.net.URL destURL = ClassLoader.getSystemResource("./video/dest.mov");

        //mit fileURL MediaLocater erzeugen

        //Datensenke mit Ausgangsdatenquelle von Prozessor und File-MediaLocator
        //erzeugen

        //DataSinkListener zu Datensenke hinzufgen,
        //der bei einem EndOfStreamEvent Datenquelle schliet

        //Datenquelle ffnen

        //Datenquelle starten

        //(Einschub nur zu Aufgabe 4: Prozessor bernimmt Steuerung des Players)

        //Prozessor starten

    }

    //zu Aufgabe 3: Prozessorereignisse behandeln
    private void handleProcessorEvents(ControllerEvent e) {
        //Wenn Prozessor fertig mit Transkodierung dann
        //1. von der Steuerung des Players entbinden (nur Aufgabe 4)
        //2. Prozessor schlieen

    }

    //zu Aufgabe 3: Kann zum schlieen der Datensenke aufgerufen werden
    private void closeSink() {
        //Datensenke schlieen

    }


    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new VideoFrame().show();
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToolBar Toolbar;
    private javax.swing.JToggleButton loopButton;
    private javax.swing.JButton markStopButton;
    private javax.swing.JButton markStartButton;
    private javax.swing.JSeparator menuSeparator;
    private javax.swing.JTextField stopTextField;
    private javax.swing.JButton saveButton;
    private javax.swing.JTextField startTextField;
    // End of variables declaration//GEN-END:variables
    //Variablendeklaration - Fortsetzung
    private Time startTime;
    private Time stopTime;
    private Player player;
    private DataSource ds;
    private DataSink sink;
    private Processor proc;

}