
package datenbank;

import java.util.*;
import exception.*;

public class ProdBewBean  {
  
   
  private String alter = "";
  private String geschlecht = "";
  private int nAlter = 0;
  private Hashtable persFehler = new Hashtable();
  private Hashtable bewertFehler = new Hashtable();
  private HashMap bewertPrm;
  private ProdBewDBAO datenbank = null;

  public void setDatenbank(ProdBewDBAO datenbank) {
    this.datenbank = datenbank;
  }

/******************************************Produkte*****************************************************/


  public Collection getProdukte() throws Exception {
    try {
        return datenbank.getProdukte();
    } catch (ProdukteNichtGefundenException ex) {
        throw ex;
    } 

  }
  
/*******************************************Teilnehmer************************************************/
  
  
  public void setAlter(String alter) {
    this.alter = alter;
  }
  
  public void setGeschlecht(String geschlecht) {
    this.geschlecht = geschlecht;
  }
    
  public String getAlter() {
    return alter;
  }
  
  public String getGeschlecht() {
    return geschlecht==null ? "" : geschlecht;
  }

  public boolean teilnValidieren(){
    boolean isOK = true;
    persFehler.clear();
    try {
      nAlter = Integer.parseInt(alter);
      if (nAlter <= 0) {
        persFehler.put("alter", "Bitte Alter angeben");
        throw new Exception();
      }
    }
    catch(Exception e) {
      persFehler.put("alter", "Bitte Alter angeben");
      isOK = false;
    }
    if (getGeschlecht().equals("")) {
      persFehler.put("geschlecht", "Bitte Geschlecht angeben");
      isOK = false;
    }
    return isOK;
  }
      

/*****************************************************Bewertung**********************************************/  
  
  public void setBewertPrm (HashMap m) {
    bewertPrm  = m;
  }
  public HashMap getBewertPrm() {
    return bewertPrm;
  }

  public String getBewertung(String s){
    String[] v;
    if (bewertPrm!=null) {
      v = (String[]) bewertPrm.get(s);
      return v[0] != null ? v[0] : "";
    }
    else
      return "";
  }
  
  public boolean bewertValidieren(){
    List bewertList = new ArrayList();
    Iterator it = bewertPrm.entrySet().iterator();
    boolean isOK = true;
    String k="";
    String[] v;
    int numKey, numVal;
    String prodNr="";
    bewertFehler.clear();
    while (it.hasNext()) {
      Map.Entry me = (Map.Entry) it.next();
      k= (String) me.getKey();
      v= (String[]) me.getValue();
      prodNr = k.substring(k.indexOf('_')+1);
      try {
        numKey = Integer.parseInt(prodNr);
        numVal = Integer.parseInt(v[0]);
        bewertList.add(new Bewertung(numKey,numVal));
        if (numVal < 0 || numVal > 5) {
          throw new Exception();
        }
      }
      catch (Exception e){
        bewertFehler.put(k, "Bitte einen Wert zwischen 0 und 5 eingeben");
        isOK = false;
      }
    }
    if (isOK)
      //datenbank
      try {
        datenbank.bewertInsert(getAlter(), getGeschlecht(), bewertList);
      }
      catch (Exception e){
        isOK = false;
      }
    return isOK;
  }
  
  
  public String getFehlerMldg(String s, String fehler) {
    String fehlerMldg;
    if (fehler.equals("p")) 
      fehlerMldg = (String) persFehler.get(s);
    else
      fehlerMldg = (String) bewertFehler.get(s);
    return (fehlerMldg != null) ? fehlerMldg : "";
  }

}
