
package datenbank;

import java.sql.*;
import javax.sql.*;
import javax.naming.*;
import java.util.*;
import exception.*;
//import cart.*;

public class ProdBewDBAO {

  private ArrayList produkte;
  Connection con;

  public ProdBewDBAO() throws Exception {

    try  { 
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      con = DriverManager.getConnection("jdbc:odbc:Produktbewertung","public","public");
    } catch (Exception ex) {
      throw new Exception("Datenbank konnte nicht geffnet werden: " + ex.getMessage());
    }       
  }

  public void remove () {
    try {
        con.close();
    } catch (SQLException ex) {
        System.out.println(ex.getMessage());
    }
  }

  public Collection getProdukte() throws ProdukteNichtGefundenException {
    produkte = new ArrayList();
    try {
      String selectStatement = "select * " + "from produkte";
      Statement stmt = con.createStatement();
      ResultSet rs = stmt.executeQuery(selectStatement);

      while (rs.next()) {
        ProduktDetails pd = new ProduktDetails(rs.getInt(1), rs.getString(2));
        produkte.add(pd);
      }
      stmt.close();
    } catch (SQLException ex) {
      throw new ProdukteNichtGefundenException(ex.getMessage());
    }

    Collections.sort(produkte);
    return produkte;
  }
  
  public Collection getProduktBew() throws ProdukteNichtGefundenException {
    produkte = new ArrayList();
    try {
      String selectStatement = "SELECT Produkte.Produkt_Nr, Produkte.Titel, Avg(Bewertung.Bewertung), Count(Teilnehmer.Geschlecht) "
                              + "FROM Teilnehmer "
                              +   "INNER JOIN (Produkte "
                              +         "INNER JOIN Bewertung "
                              +         "ON Produkte.Produkt_Nr = Bewertung.Produkt_Nr) " 
                              +   "ON Teilnehmer.Teiln_Nr = Bewertung.Teiln_Nr "
                              + "GROUP BY Produkte.Produkt_Nr, Produkte.Titel "
                              + "ORDER BY Avg(Bewertung.Bewertung) DESC;";
      Statement stmt = con.createStatement();
      ResultSet rs = stmt.executeQuery(selectStatement);

      while (rs.next()) {
        ProduktDetails pd = new ProduktDetails(rs.getInt(1), rs.getString(2), rs.getDouble(3), rs.getInt(4));
        produkte.add(pd);
      }
      stmt.close();
    } catch (SQLException ex) {
      throw new ProdukteNichtGefundenException(ex.getMessage());
    }

    return produkte;
  }
  
  public void bewertInsert(String alter, String geschlecht, List bewertungen) throws Exception {
    String insertStr = "Insert into teilnehmer ( alter , geschlecht ) values ( "  
                                              + alter + " , '" + geschlecht + "' ) ;";
    try {
      con.setAutoCommit(false);
      Statement stmt = con.createStatement();
      stmt.execute(insertStr);
      ResultSet rs;
      rs = stmt.executeQuery("Select last (teiln_nr) from teilnehmer");
      rs.next();
      int teilnId = rs.getInt(1);
      stmt.close();
      PreparedStatement prepStmt = con.prepareStatement
              ("Insert into bewertung ( teiln_nr , produkt_nr , bewertung ) values ( ? , ? , ? ) ; ");
      Iterator it = bewertungen.iterator();
      while (it.hasNext()) {
        Bewertung bew = (Bewertung) it.next();
        prepStmt.setInt(1, teilnId);
        prepStmt.setInt(2, bew.getProdId());
        prepStmt.setInt(3, bew.getBewertung());
        prepStmt.execute();
      }
      prepStmt.close();
      con.commit();
    }
    catch (Exception e) {
      con.rollback();
      throw new DsEinfuegenException("Bewertungen konnten nicht gespeichert werden");
    }
  }
  public String getTeilnZahl(String s) {
    try {
      Statement stmt = con.createStatement();
      String anfang = "Select count(*) from teilnehmer";
      String gesCond =" where geschlecht = " + ((s =="m") ? "'m';" : (s == "w") ? "'w';" : ""); 
      String altCond =" where alter between " + ((s == "18") ? "18 and 29;" : "30 and 90;");
      String selectString="";
      if (s == "a")
          selectString = anfang + (s=="a" ? ";" : gesCond);
      if (s=="m" || s == "w")
          selectString = anfang + gesCond;
      if (s=="18" || s == "30")
          selectString = anfang + altCond;       
      ResultSet rs = stmt.executeQuery(selectString);
      rs.next();
      String anzahl = rs.getString(1);
      stmt.close();
      return anzahl;
    }
    catch (Exception e){
      System.out.println(e.getMessage());
      return "";
    }
  }
}
