
package listeners;

import datenbank.ProdBewDBAO;
import javax.servlet.*;

public final class ContextListener
    implements ServletContextListener {
    private ServletContext context = null;

    public void contextInitialized(ServletContextEvent event) {
         context = event.getServletContext();
         
         try {
            ProdBewDBAO prodBewDBAO = new ProdBewDBAO();
            context.setAttribute("prodBewDB", prodBewDBAO);
         } catch (Exception ex) {
            context.log("ProdBewDB Bean konnte nicht instantiiert werden: " + ex.getMessage());
         }
    }
      
    public void contextDestroyed(ServletContextEvent event) {
         context = event.getServletContext();
         ProdBewDBAO prodBewDB = (ProdBewDBAO)context.getAttribute("prodBewDB");
         prodBewDB.remove();
         context.removeAttribute("prodBewDB");
    }
}
