import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;


public class ImageRead {
	
	static String filename = "./images/vangogh.jpg";
	

	//ImageIO
	public static BufferedImage readImageStream(String file) {
		//String[] formats = (ImageIO.getReaderFormatNames()); //kann man vorab abprfen, welche Formate untersttzt werden
		try {
			return ImageIO.read(new File(file));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	//JPEG Decoder aus dem Paket com.sun.image.codec.jpeg.*
	public static BufferedImage readJPEG(String file){
		InputStream in;
		try {
			in = new FileInputStream(file);
			JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder(in);
			BufferedImage img = decoder.decodeAsBufferedImage();
			in.close();
			return img;
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ImageFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return null;
		
	}
	
	
}
