

import numpy as np   
import matplotlib.pyplot as plt  
import matplotlib
    
  
def zone_f( coords, center, k =0.001):
    deltaX = center[0] - coords[0]
    deltaY = center[1] - coords[1]
    return np.cos (k * ( deltaX * deltaX + deltaY * deltaY ))

def subsample(grayscale, factor):
    img = np.zeros((grayscale.shape[0]/factor, grayscale.shape[1]/factor))
    for i in xrange( img.shape[0] ):
        for j in xrange( img.shape[1] ):
            img[i][j] = grayscale[i*factor][j*factor]
    return img    

N=512
center = np.array([35 ,60])
plate_img = np.zeros((N ,N ))

for i in xrange ( plate_img.shape [0]):
    for j in xrange ( plate_img.shape [1]):
        plate_img[i][j] = zone_f( np.array([i,j]), center)




plt.subplot(321)
plt.imshow(plate_img)
plt.title('zone plate')
plt.gray()

plt.subplot(323)
plt.imshow( subsample(plate_img, 2) )
plt.title('subsample=2')

plt.subplot(324)
plt.imshow( subsample(plate_img, 4) )
plt.title('subsample=4')

plt.subplot(325)
plt.imshow( subsample(plate_img, 8) )
plt.title('subsample=8')

plt.subplot(326)
plt.imshow( subsample(plate_img, 16) )
plt.title('subsample=16')

plt.show()