'''
Created on Jun 22, 2011

@author: svenkratz, michael.rohs
'''

import numpy as np
import os



def to_pgm(filename, arr):
	print "Writing PGM to:", os.path.realpath(filename)
	f = open(filename, 'w')
	f.write('P2\n')
	h,w = arr.shape
	f.write("# Generated by pgm.py, LMU Munich\n")
	f.write(str(w)+" "+str(h)+"\n")
	f.write("255\n")
	# normalize to 0..255
	
	min = np.min(arr)
	
	# get rid of neg. / offset min value
	arr = arr-min
	max = np.max(arr)
	arr = arr/max * 255
	
	print "Min/Max", arr.min(), arr.max()
	
	for j in xrange(h):
		for i in xrange(w):
			f.write(str(int(arr[j,i])) + " ")
		f.write('\n')
	f.close()
	print "Success!"

			
			
def read_pgm(filename):
	print "Reading PGM from:", os.path.realpath(filename)
	f = open(filename, 'r')
	f.readline()
	f.readline() 
	w,h = f.readline().split()
	w = int(w)
	h = int(h)
	print 'width = ' + str(w)
	print 'height = ' + str(h)
	
	arr = np.zeros((h,w), 'float32')
	
	m = f.readline()
	m = float(m)
	print 'max = ' + str(m)
	
	n = w * h
	x = 0
	y = 0
	while n > 0:
		r = f.readline().split()
		for i in xrange(len(r)):
			arr[y,x] = float(r[i]) / m
			x = x + 1
			if x >= w: 
				x = 0
				y = y + 1
			n = n - 1

	print "Success!"

	return arr



def imread(filename):
	return read_pgm(filename)



def imsave(filename, arr, maxLevel=255):
	print "Writing PGM to:", os.path.realpath(filename)
	f = open(filename, 'w')
	f.write('P2\n')
	h,w = arr.shape
	f.write("# Generated by pgm.py, LMU Munich\n")
	f.write(str(w)+" "+str(h)+"\n")
	f.write(str(maxLevel) + "\n")
	
	min = np.min(arr)
	# get rid of neg. / offset min value
	arr = arr-min
	max = np.max(arr)
	arr = float(maxLevel) * arr / max + 0.5
	
	print "Min/Max", arr.min(), arr.max()
	
	for j in xrange(h):
		for i in xrange(w):
			f.write(str(int(arr[j,i])) + " ")
		f.write('\n')
	f.close()
	print "Success!"
