# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="Johannes Hohlbein"
__date__ ="$29.05.2013 10:23:44$"

import pygame

# Dient der Repraesentation eines Gegners
class Enemy(pygame.sprite.Sprite):

    def __init__(self, current_koord, animation):
        """Erstellt einen Gegner - Hehuf"""
        pygame.sprite.Sprite.__init__(self)
        self.animation = animation
        self.current_koord = current_koord
        self.image = animation.get_frame(0)
        self.width = self.image.get_width()
        self.height = self.image.get_height()
        self.rect = self.image.get_rect()
        self.rect.topleft = (current_koord.x_koord - self.width / 2, current_koord.y_koord -self.height / 2)
        self.health = 1

    def move(self, movement_vector):
        """Bewegt einen Gegner - Hehuf"""
        self.current_koord.add(movement_vector)

    def being_hit(self):
        """Wird aufgerufen wenn ein Gegner getroffen wurde"""
        new_frames = []
        for frame in self.animation.frames:
            new_frames.append(pygame.transform.smoothscale(frame, (frame.get_width() / 2, frame.get_height() / 2)))
        self.animation.set_frames(new_frames)
        self.animation.set_delta(new_frames[0].get_width() / 2, new_frames[0].get_height() / 2)
        self.width = new_frames[0].get_width()
        self.height = new_frames[0].get_height()
        self.health -= 1
        return self.health <= 0

    def update(self, time_passed):
        self.image = self.animation.get_frame(time_passed)
        self.rect = self.image.get_rect()
        self.rect.topleft = (self.current_koord.x_koord - self.width / 2, self.current_koord.y_koord - self.height / 2)

    def shoot(self):
        print "shot"

