import math
from spriteanimation import Animation
from enemy import Enemy
from star import Star
import pygame
import random
from pygame.locals import *
from sys import exit
from vector2 import Vector2d
import pygame.gfxdraw
import enemy

# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="Johannes Hohlbein"
__date__ ="$29.05.2013 08:40:07$"

def set_frames(width, height, filename):
    master = pygame.image.load(filename).convert_alpha()
    frames = []
    sub_width=master.get_width() / width
    sub_heigth=master.get_height() / height
  
    for i in range(width * height):
        frames.append(master.subsurface((sub_width *(i % width), sub_heigth * (i / width), sub_width, sub_heigth)))
    return frames

def update_player(time_passed):
    player.image = player_animation.get_frame(time_passed)                                 # Das zugehoerige Image gesetzt
    player.mask = pygame.mask.from_surface(player.image)
    player.rect = player.image.get_rect()                           # Das zugehoerige Rechteck gesetzt
    player.rect.topleft = (player_current_koord.x_koord - delta_x_player, player_current_koord.y_koord - delta_y_player)

def reset_enemies():
    while len(enemies) < number_enemies:   #Initialisieren der Gegner
        if random.randint(0,2) == 0:
            enemy_animation = Animation(enemy_frames,(len(enemies) % limit) * enemy_frames[0].get_width() + enemy_frames[0].get_width() / 2, enemy_frames[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames[0].get_height(), True)
        elif random.randint(0,2) == 1:
            enemy_animation = Animation(enemy_frames_2,(len(enemies) % limit) * enemy_frames_2[0].get_width() + enemy_frames_2[0].get_width() / 2, enemy_frames_2[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames_2[0].get_height(), True)
        else:
            enemy_animation = Animation(enemy_frames_3,(len(enemies) % limit) * enemy_frames_3[0].get_width() + enemy_frames_3[0].get_width() / 2, enemy_frames_3[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames_3[0].get_height(), True)
        enemy = Enemy(Vector2d((len(enemies) % limit) * enemy_frames[0].get_width() + enemy_frames[0].get_width() / 2, enemy_frames[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames[0].get_height() + screen_height / 8), enemy_animation)
        enemies.add(enemy)

bullet_image = 'images/bullet.png'     # Die Pfadangabe
life_image = 'images/life.png'         # Pfad
enemy_shot_image = 'images/enemyShot.png' # Pfad
asteroid_image = 'images/asteroid.png'     #Pfad


player_sprite_sheet = 'images/spaceship.png'            # Die Pfadangabe
explosion_sprite_sheet = 'images/explosionSheet.png'    # Die Pfadangabe
hit_sprite_sheet = 'images/hitSheet.png'                # Die Pfadangabe
shot_sprite_sheet = 'images/shotSheet.png'              # Die Pfadangabe
enemy_sprite_sheet = 'images/enemySheet.png'            # Die Pfadangabe
enemy_sprite_sheet_2 = 'images/enemySheet2.png'         # Die Pfadangabe
enemy_sprite_sheet_3 = 'images/enemySheet3.png'         # Die Pfadangabe
right_sprite_sheet = 'images/rightSheet.png'            # Die Pfadangabe
left_sprite_sheet = 'images/leftSheet.png'            # Die Pfadangabe
plus_one_sprite_sheet = 'images/plus1.png'              #Pfad
plus_ten_sprite_sheet = 'images/plus10.png'              #Pfad
mothership_sprite_sheet = 'images/motherShip.png'

enemy_laser_sound_file ='sounds/enemyLaser.ogg'
laser_sound_file = 'sounds/laser.ogg'              # Die Pfadangabe
explosion_sound_file = 'sounds/explosion.ogg'      # Die Pfadangabe
music_sound_file = 'sounds/music.wav'              # Die Pfadangabe

enemies = set()                 # Die Gegner
bullets = set()                 # Die Schuesse
stars = set()                   # Die Sterne
asteroids = set()               # Die Asteroiden
animations = set()              # Die Animationen
enemy_bullets = set()
mothership = None

screen_width = 800          # Initialisieren der Breite der Leinwand
screen_height = 600         # Initialisieren der Hoehe der Leinwand
number_enemies = 24         # Die Anzahl an Gegnern
number_asteroids = 4        # Anzahl Asteroiden

explosion_sprite_sheet_columns = 4    # Die Anzahl Spalten im SpriteSheet
explosion_sprite_sheet_rows = 3       # Die ANzahl an Zeilen im SpriteSheet

hit_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
hit_sprite_sheet_rows = 3       # Die ANzahl an Zeilen im SpriteSheet

shot_sprite_sheet_columns = 2    # Die Anzahl Spalten im SpriteSheet
shot_sprite_sheet_rows = 2       # Die ANzahl an Zeilen im SpriteSheet

enemy_sprite_sheet_columns = 4    # Die Anzahl Spalten im SpriteSheet
enemy_sprite_sheet_rows = 3      # Die ANzahl an Zeilen im SpriteSheet

player_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
player_sprite_sheet_rows = 2      # Die ANzahl an Zeilen im SpriteSheet

right_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
right_sprite_sheet_rows = 2      # Die ANzahl an Zeilen im SpriteSheet

left_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
left_sprite_sheet_rows = 2      # Die ANzahl an Zeilen im SpriteSheet

plus_one_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
plus_one_sprite_sheet_rows = 3      # Die ANzahl an Zeilen im SpriteSheet

plus_ten_sprite_sheet_columns = 3    # Die Anzahl Spalten im SpriteSheet
plus_ten_sprite_sheet_rows = 3      # Die ANzahl an Zeilen im SpriteSheet

mothership_sprite_sheet_columns = 4    # Die Anzahl Spalten im SpriteSheet
mothership_sprite_sheet_rows = 3      # Die ANzahl an Zeilen im SpriteSheet

player_current_koord = Vector2d(screen_width / 2,  screen_height * 5 / 6)   # Startkoordinaten des Spielers

pygame.mixer.init(frequency=22050, size=-16, channels=2, buffer=512)
laser_sound = pygame.mixer.Sound(laser_sound_file)
laser_sound.set_volume(0.3)

explosion_sound = pygame.mixer.Sound(explosion_sound_file)
explosion_sound.set_volume(0.8)

enemy_laser_sound = pygame.mixer.Sound(enemy_laser_sound_file)
enemy_laser_sound.set_volume(1.0)

pygame.mixer.music.load(music_sound_file)
pygame.mixer.music.play(-1)

pygame.init()                                                           # Initialisieren
screen = pygame.display.set_mode((screen_width, screen_height), 0, 32)  # Breite und Hoehe setzen
pygame.display.set_caption("Blechner-Bua")                              # Blaukraut-Uffing

score_font = pygame.font.SysFont("courier", 30)                         #Der Punktestand
score_text = score_font.render("Score: " + str(0), True, (255, 255, 255))

got_it_font = pygame.font.SysFont("courier", 30, True)
got_it_text = got_it_font.render("Got it!!!", True, (255,255,255))

appear_time = -3
got_it_loc = None

end_font = pygame.font.SysFont("courier", 72, True)

win = end_font.render("You Win!!!", True, (255, 255, 255))              # Gewinn und Verlust Meldung
lost = end_font.render("You Lost!!!", True, (255, 255, 255))
quit = score_font.render("press ESC to quit", True, (255, 255, 255))

player_frames = set_frames(player_sprite_sheet_columns, player_sprite_sheet_rows, player_sprite_sheet)
player_animation = Animation(player_frames, player_current_koord.x_koord, player_current_koord.y_koord, True)
player = pygame.sprite.Sprite()                                 # Das Panzer sprite wird erstellt
player_lives = 5
player_life_image = pygame.image.load(life_image).convert_alpha()

delta_x_player = player_frames[0].get_width() / 2                   # Wird benoetigt um den Spieler an der richtigen Stelle zu zeichnen
delta_y_player = player_frames[0].get_height() / 2                  # Wird benoetigt um den Spieler an der richtigen Stelle zu zeichnen

right_frames = set_frames(right_sprite_sheet_columns, right_sprite_sheet_rows, right_sprite_sheet)
right_animation = Animation(right_frames, player_current_koord.x_koord, player_current_koord.y_koord, True)

left_frames = set_frames(left_sprite_sheet_columns, left_sprite_sheet_rows, left_sprite_sheet)
left_animation = Animation(left_frames, player_current_koord.x_koord, player_current_koord.y_koord, True)

plus_one_frames = set_frames(plus_one_sprite_sheet_columns, plus_one_sprite_sheet_rows, plus_one_sprite_sheet)
plus_ten_frames = set_frames(plus_ten_sprite_sheet_columns, plus_ten_sprite_sheet_rows, plus_one_sprite_sheet)

mothership_frames = set_frames(mothership_sprite_sheet_columns, mothership_sprite_sheet_rows, mothership_sprite_sheet)
mothership_animation = Animation(mothership_frames, 0, 0, True)

update_player(0)

move_right = True       # Geibt an ob sich die Gegner rechts bewegen
move_down = False       # Gibts an ob sich die Gegner nach unten bewegen
steps = 0
enemy_speed = 1
score = 0

game_lost = False

explosion_frames = set_frames(explosion_sprite_sheet_columns, explosion_sprite_sheet_rows, explosion_sprite_sheet)   # Die Explosionsbilder
hit_frames = set_frames(hit_sprite_sheet_columns, hit_sprite_sheet_rows, hit_sprite_sheet)
shot_frames = set_frames(shot_sprite_sheet_columns, shot_sprite_sheet_rows, shot_sprite_sheet)
enemy_frames = set_frames(enemy_sprite_sheet_columns, enemy_sprite_sheet_rows, enemy_sprite_sheet)
enemy_frames_2 = set_frames(enemy_sprite_sheet_columns, enemy_sprite_sheet_rows, enemy_sprite_sheet_2)
enemy_frames_3 = set_frames(enemy_sprite_sheet_columns, enemy_sprite_sheet_rows, enemy_sprite_sheet_3)
#asteroid_frames = set_frames(asteroid_sprite_sheet_columns, asteroid_sprite_sheet_rows, asteroid_sprite_sheet)

clock = pygame.time.Clock()
#limit = int(screen_width / enemy_frames[0].get_width()) / 2
limit = 8
all_time = 0
time_to_next_shot = 4
next_shot = 3
next_mothership = 3

reset_enemies()

#while len(enemies) < number_enemies:   #Initialisieren der Gegner
 #   if random.randint(0,2) == 0:
  #      enemy_animation = Animation(enemy_frames,(len(enemies) % limit) * enemy_frames[0].get_width() + enemy_frames[0].get_width() / 2, enemy_frames[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames[0].get_height(), True)
   # elif random.randint(0,2) == 1:
    #    enemy_animation = Animation(enemy_frames_2,(len(enemies) % limit) * enemy_frames_2[0].get_width() + enemy_frames_2[0].get_width() / 2, enemy_frames_2[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames_2[0].get_height(), True)
    #else:
     #   enemy_animation = Animation(enemy_frames_3,(len(enemies) % limit) * enemy_frames_3[0].get_width() + enemy_frames_3[0].get_width() / 2, enemy_frames_3[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames_3[0].get_height(), True)
    #enemy = Enemy(Vector2d((len(enemies) % limit) * enemy_frames[0].get_width() + enemy_frames[0].get_width() / 2, enemy_frames[0].get_height() / 2 + int(len(enemies) / limit) * enemy_frames[0].get_height() + screen_height / 8), enemy_animation)
   # enemies.add(enemy)

for i in range(number_asteroids):
    asteroid = pygame.sprite.Sprite()
    angle = random.randint(-180,180)
    asteroid.image = pygame.image.load(asteroid_image).convert_alpha()
    asteroid.image = pygame.transform.rotate(asteroid.image, angle)
    asteroid.mask = pygame.mask.from_surface(asteroid.image)
    asteroid.rect = asteroid.image.get_rect()                           # Das zugehoerige Rechteck gesetzt
    asteroid.rect.topleft = (i * screen_width / 5 + screen_width / 5 - asteroid.image.get_width() / 2, player_current_koord.y_koord - delta_y_player * 2 - asteroid.image.get_height() / 2)
    asteroids.add(asteroid)

while True:

    pygame.time.wait(8) # Damit die geschwindigkeit nicht von der Rechnergeschwindigkeit abhaengt
    time_passed = float(clock.tick()) / 1000

    to_delete = set()
    player_moving_left = False
    player_moving_right = False
    update_player(time_passed)

    all_time += time_passed
    enemy_count = len(enemies)

    if all_time >= next_shot:
        who_shoots = random.randint(0,len(enemies) - 1)
        time_to_next_shot = math.sqrt(time_to_next_shot)
        next_shot = all_time + time_to_next_shot
    else:
        who_shoots = len(enemies)

    for event in pygame.event.get():    # Abfangen der Events
        if event.type == QUIT:
            exit()
        elif event.type == pygame.KEYDOWN:
            if not (game_lost) and event.key == pygame.K_SPACE and len(bullets) <= 0:
                laser_sound.play()
                bullet = pygame.sprite.Sprite()  # Neuer Schuss
                bullet.image = pygame.image.load(bullet_image).convert_alpha()
                bullet.mask = pygame.mask.from_surface(bullet.image)
                bullet.rect = bullet.image.get_rect()                           # Das zugehoerige Rechteck gesetzt
                bullet.rect.topleft = (player_current_koord.x_koord - bullet.image.get_width() + 2, player_current_koord.y_koord - bullet.image.get_height() / 2)
                bullets.add(bullet)
                new_shot = Animation(shot_frames, player_current_koord.x_koord - 1, player_current_koord.y_koord - 70, False)
                new_shot.set_framerate(50)
                animations.add(new_shot)
            elif (game_lost) and event.key == pygame.K_ESCAPE:
                exit()

    if not (game_lost) and pygame.key.get_pressed()[pygame.K_LEFT] and player_current_koord.x_koord - delta_x_player > 0:
        player_current_koord.add(Vector2d(-2, 0))
        player.rect.topleft = (player_current_koord.x_koord - delta_x_player, player_current_koord.y_koord - delta_y_player)
        player_moving_left = True
    if not (game_lost) and pygame.key.get_pressed()[pygame.K_RIGHT] and player_current_koord.x_koord + delta_x_player < screen_width:
        player_current_koord.add(Vector2d(2, 0))
        player.rect.topleft = (player_current_koord.x_koord - delta_x_player, player_current_koord.y_koord - delta_y_player)
        player_moving_right = True
        
    screen.fill((0, 0, 0))        # Hintergrundfarbe setzen

    if random.randint(0,4) == 0:
        stars.add(Star(screen_width))

    for star in stars:
        pygame.gfxdraw.filled_circle(screen, star.current_koord.x_koord, star.current_koord.y_koord, star.radius, (255,255,255))
        star.move()
        if star.current_koord.y_koord-star.radius > screen_height:
            to_delete.add(star)

    if not game_lost:
        if move_down:
            move_vector = Vector2d(0,enemy_speed)
            for enemy in enemies:
                enemy.move(move_vector)
                if enemy.current_koord.y_koord >= screen_height:
                    game_lost = True
            steps += 1
            if steps == 50:
                move_right = not move_right
                move_down = False
                steps = 0
        else:
            if move_right:
                move_vector = Vector2d(enemy_speed,0)
                for enemy in enemies:
                    enemy.move(move_vector)
                    if enemy.current_koord.x_koord + enemy.width / 2 >= screen_width:
                        move_down = True
            else:
                move_vector = Vector2d(-enemy_speed,0)
                for enemy in enemies:
                    enemy.move(move_vector)
                    if enemy.current_koord.x_koord - enemy.width / 2 <= 0:
                        move_down = True

    if all_time >= next_mothership:
        mothership = pygame.sprite.Sprite()
        mothership.image = mothership_animation.get_frame(time_passed)
        mothership.mask = pygame.mask.from_surface(mothership.image)
        mothership.rect = mothership.image.get_rect()                           # Das zugehoerige Rechteck gesetzt
        mothership.rect.topleft = (-mothership.image.get_width(), 50)
        next_mothership = all_time + random.randint(5,10)

    for bullet in bullets:
        bullet.rect.topleft = (bullet.rect.topleft[0], bullet.rect.topleft[1] - 5)
        screen.blit(bullet.image, bullet.rect.topleft)
        for asteroid in asteroids:
            if pygame.sprite.collide_mask(asteroid, bullet):
                to_delete.add(bullet)
                collision_point = pygame.sprite.collide_mask(asteroid, bullet)
                for i in range(5):
                    for j in range(5):
                        asteroid.image.set_at((collision_point[0] - i ,collision_point[1] - j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] - i ,collision_point[1] + j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] + i ,collision_point[1] - j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] + i ,collision_point[1] + j),(0,0,0,0))
                new_hit = Animation(hit_frames, bullet.rect.topleft[0] + bullet.image.get_width() / 2, bullet.rect.topleft[1], False)
                new_hit.set_framerate(35)
                animations.add(new_hit)
                asteroid.mask = pygame.mask.from_surface(asteroid.image)
        if not mothership == None:
            if pygame.sprite.collide_mask(mothership, bullet):
                to_delete.add(bullet)
                new_hit = Animation(hit_frames, bullet.rect.topleft[0] + bullet.image.get_width() / 2, bullet.rect.topleft[1], False)
                new_hit.set_framerate(35)
                animations.add(new_hit)
                explosion_sound.play()
                new_explosion = Animation(explosion_frames, mothership.rect.topleft[0] + mothership.image.get_width() / 2, mothership.rect.topleft[1] + mothership.image.get_height() / 2, False)
                new_explosion.set_framerate(40)
                animations.add(new_explosion)
                new_plus_ten = Animation(plus_ten_frames, mothership.rect.topleft[0] + mothership.image.get_width() / 2, mothership.rect.topleft[1] + mothership.image.get_height() / 2, False)
                animations.add(new_plus_ten)
                score += 10
                got_it_loc = (mothership.rect.topleft[0] + mothership.image.get_width() / 2 - got_it_text.get_width() / 2, mothership.rect.topleft[1] + mothership.image.get_height() / 2 - got_it_text.get_height() / 2)
                appear_time = all_time
                mothership = None
        if bullet.rect.topleft[1] < - bullet.image.get_height():
            to_delete.add(bullet)

    he_shoots = 0;
    for enemy in enemies:          # Zeichnen der Gegner
        enemy.update(time_passed)
        screen.blit(enemy.image, (enemy.current_koord.x_koord - enemy.width / 2, enemy.current_koord.y_koord - enemy.height / 2))
        if he_shoots == who_shoots:
            enemy_laser_sound.play()
            enemy_bullet = pygame.sprite.Sprite()  # Neuer Schuss
            enemy_bullet.image = pygame.image.load(enemy_shot_image).convert_alpha()
            enemy_bullet.mask = pygame.mask.from_surface(enemy_bullet.image)
            enemy_bullet.rect = enemy_bullet.image.get_rect()                           # Das zugehoerige Rechteck gesetzt
            enemy_bullet.rect.topleft = (enemy.current_koord.x_koord - enemy_bullet.image.get_width() / 2, enemy.current_koord.y_koord - enemy_bullet.image.get_height() / 2)
            enemy_bullets.add(enemy_bullet)
        he_shoots += 1
        for bullet in bullets:
            if pygame.sprite.collide_mask(enemy, bullet):
                new_hit = Animation(hit_frames, bullet.rect.topleft[0] + bullet.image.get_width() / 2, bullet.rect.topleft[1], False)
                new_hit.set_framerate(35)
                animations.add(new_hit)
                to_delete.add(bullet)
                if enemy.being_hit():
                    explosion_sound.play()
                    to_delete.add(enemy)
                    new_explosion = Animation(explosion_frames, enemy.current_koord.x_koord, enemy.current_koord.y_koord, False)
                    new_explosion.set_framerate(40)
                    animations.add(new_explosion)
                    new_plus_one = Animation(plus_one_frames, enemy.current_koord.x_koord, enemy.current_koord.y_koord, False)
                    animations.add(new_plus_one)
        if pygame.sprite.collide_mask(player, enemy):
            player_lives = 0

    for asteroid in asteroids:
        screen.blit(pygame.transform.chop(asteroid.image, asteroid.rect), asteroid.rect.topleft)
                    
    for enemy_bullet in enemy_bullets:
        enemy_bullet.rect.topleft = (enemy_bullet.rect.topleft[0], enemy_bullet.rect.topleft[1] + 5)
        screen.blit(enemy_bullet.image, enemy_bullet.rect.topleft)
        if pygame.sprite.collide_mask(player, enemy_bullet):
            new_hit = Animation(hit_frames, enemy_bullet.rect.topleft[0] + enemy_bullet.image.get_width() / 2, enemy_bullet.rect.topleft[1], False)
            new_hit.set_framerate(35)
            animations.add(new_hit)
            to_delete.add(enemy_bullet)
            player_lives -= 1
        for asteroid in asteroids:
            if pygame.sprite.collide_mask(asteroid, enemy_bullet):
                to_delete.add(enemy_bullet)
                collision_point = pygame.sprite.collide_mask(asteroid, enemy_bullet)
                for i in range(5):
                    for j in range(5):
                        asteroid.image.set_at((collision_point[0] - i ,collision_point[1] - j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] - i ,collision_point[1] + j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] + i ,collision_point[1] - j),(0,0,0,0))
                        asteroid.image.set_at((collision_point[0] + i ,collision_point[1] + j),(0,0,0,0))
                new_hit = Animation(hit_frames, enemy_bullet.rect.topleft[0] + enemy_bullet.image.get_width() / 2, enemy_bullet.rect.topleft[1], False)
                new_hit.set_framerate(35)
                animations.add(new_hit)
                asteroid.mask = pygame.mask.from_surface(asteroid.image)
        if enemy_bullet.rect.topleft[1] > screen_height:
            to_delete.add(enemy_bullet)

    if not mothership == None:
        mothership.rect.topleft = (mothership.rect.topleft[0] + 5, mothership.rect.topleft[1])
        mothership.image = mothership_animation.get_frame(time_passed)
        mothership.mask = pygame.mask.from_surface(mothership.image)
        screen.blit(mothership.image, mothership.rect.topleft)
        if mothership.rect.topleft[0] >= screen_width:
            mothership = None

        
    for animation in animations:
        if not animation.over:
            screen.blit(animation.get_frame(time_passed), (animation.current_koord.x_koord - animation.delta_x, animation.current_koord.y_koord - animation.delta_y))
        else:
            to_delete.add(animation)

    screen.blit(player.image, (player_current_koord.x_koord - delta_x_player, player_current_koord.y_koord-delta_y_player))  # Zeichnen der Spielfigur
    if player_moving_right:
        current_right_frame = right_animation.get_frame(time_passed)
        screen.blit(current_right_frame, (player_current_koord.x_koord - delta_x_player - current_right_frame.get_width() / 4, player_current_koord.y_koord - current_right_frame.get_height() / 4))
    if player_moving_left:
        current_left_frame = left_animation.get_frame(time_passed)
        screen.blit(current_left_frame, (player_current_koord.x_koord + delta_x_player - current_left_frame.get_width() * 4 / 5 , player_current_koord.y_koord - current_left_frame.get_height() / 4))

    for i in range(player_lives):
        screen.blit(player_life_image, (screen_width - 1.1 * player_life_image.get_width() * (i + 1) , 0))

    bullets.difference_update(to_delete)
    enemies.difference_update(to_delete)
    animations.difference_update(to_delete)
    stars.difference_update(to_delete)
    asteroids.difference_update(to_delete)
    enemy_bullets.difference_update(to_delete)

    if not all_time - appear_time > 3:
        screen.blit(got_it_text, (got_it_loc[0], got_it_loc[1]))

    score = score + (enemy_count - len(enemies))
    score_text = score_font.render("Score: " + str(score), True, (255, 255, 255))
    screen.blit(score_text, (0, 0))
    
    if len(enemies) == 0:
        reset_enemies()
        move_right = True       # Geibt an ob sich die Gegner rechts bewegen
        move_down = False       # Gibts an ob sich die Gegner nach unten bewegen
        steps = 0
        enemy_speed = enemy_speed * 1.2
    if player_lives == 0:
        game_lost = True

    if game_lost:
        screen.blit(lost, ((screen_width - win.get_width()) / 2, (screen_height - win.get_height()) / 2))
        screen.blit(quit, ((screen_width - quit.get_width()) / 2, (screen_height + win.get_height()) / 2))

    pygame.display.update()     # Updaten des Display