from vector2 import Vector2d
# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="Heauf"
__date__ ="$03.06.2013 18:09:52$"


class Animation:

    def __init__(self, frames, x_koord, y_koord, endless):
        """Erstellt eineObjekt vom Typ Animation"""
        self.endless = endless
        self.frames = frames
        self.time_passed = 0.0
        self.current_koord = Vector2d(x_koord, y_koord)
        self.current_frame = frames[0]
        self.framerate = 30
        self.over = False
        self.delta_x = frames[0].get_width() / 2
        self.delta_y = frames[0].get_height() / 2

    def set_frames(self, frames):
        self.frames = frames

    def set_delta(self, delta_x, delta_y):
        self.delta_x = delta_x
        self.delta_y = delta_y

    def add_frame(self, Surface, pos):
        self.frames.insert(pos, Surface)

    def replace_frame(self, Surface, pos):
        first = self.frames[0:pos]
        last=self.frames[pos+1:len(self.frames)]
        first.append(Surface)
        first.extend(last)
        self.frames = first

    def remove_frame(self, pos):
        first = self.frames[0:pos]
        last = self.frames[pos+1:len(self.frames)]
        first.extend(last)
        self.frames = first

    def set_framerate(self, rate):
        self.framerate = rate

    def get_frame(self, time_passed):
        self.time_passed += time_passed
        current_frame = int(self.time_passed * self.framerate)
        if self.endless:
            current_frame = current_frame % len(self.frames)
        if current_frame >= len(self.frames):
             self.over = True
             return self.frames[len(self.frames) - 1]
        return self.frames[current_frame]

    def reset_animation(self):
        self.time_passed = 0;

