
import pygame
import math
from pygame.locals import *

class Box(pygame.sprite.Sprite):
    def __init__(self, color, initial_position):
        pygame.sprite.Sprite.__init__(self)
        self.image = pygame.Surface((100,100),pygame.SRCALPHA,32)
        pygame.draw.rect(self.image,color,(0,0,100,100))
        self.rect = self.image.get_rect()
        self.rect.topleft = initial_position
        self.color = color
        self.collide = False

    def update(self):
        if self.collide:
            print "collide"
            pygame.draw.rect(self.image,(255,0,255),(0,0,100,100))
        else:
            pygame.draw.rect(self.image,self.color,(0,0,100,100))
            

pygame.init()
screen = pygame.display.set_mode((640, 480), 0, 32)
boxes = ([(255,0,0),(0,200)],[(0,255,0),(150,200)])
box1 = Box((0,100,255),(250,250))
sprites = pygame.sprite.Group()
for box in boxes:
    sprites.add(Box(box[0],box[1]))

clock = pygame.time.Clock()

while True:
    for event in pygame.event.get():
        if event.type == QUIT:
            exit()
        if event.type == MOUSEMOTION:
            box1.rect.center = pygame.mouse.get_pos()
            
    for sprite in pygame.sprite.spritecollide(box1,sprites,False):
        sprite.collide = True
                
    screen.fill((0, 0, 0))
    sprites.update()
    sprites.draw(screen)
    screen.blit(box1.image,box1.rect)
    pygame.display.update()

    #set back to original color
    for sprite in sprites:
        sprite.collide = False
