import pygame
from pygame.locals import*

class Animation():
    def __init__(self, surfaces):
        self.surfaces = surfaces
        self.fps = 0
        self.act_frame = 0
        
    def get_act_frame(self):
        return self.act_frame
        
    def set_frames(self, frame_list):
        self.surfaces = frame_list
    
    def add_frame(self, Surface, *pos):
        if 0 <= pos <= len(self.surfaces):
            self.surfaces.insert(Surface, pos)
        elif pos < 0:
            self.surfaces.insert(0, Surface)
        else:
            self.surfaces.append(Surface)
    
    def replace_frame(self, Surface, pos):
        self.surfaces[pos] = Surface
    
    def remove_frame(self, pos):
        self.surfaces.remove(pos)
    
    def set_framerate(self, rate):
        if rate <= len(self.surfaces):
            self.fps = rate
        else: 
            self.fps = rate % len(self.surfaces)
    
    def get_frame(self, time_passed):
        i = len(self.surfaces) / self.fps
        time_op = time_passed % 1
        self.act_frame = (i*time_op)*self.fps
        return self.surfaces[int(self.act_frame)]
    
    def reset_animation(self):
        self.act_frame = 0
    
#class to grab pictures
class SpriteSheet(object):
    sprite_sheet = None
    
    def __init__(self, file_name):
        self.sprite_sheet = pygame.image.load(file_name).convert_alpha()
        
    def get_image(self, x, y, width, height):
        image = pygame.Surface([width, height]).convert_alpha()
        image.blit(self.sprite_sheet, (0, 0), (x, y, width, height))
        image.set_colorkey((0,0,0))
        return image