__author__ = 'hussmann'

import pygame
from pygame.locals import *
from sys import exit

background_imgfile = "roses.jpg"
sprite_imgfile = "magnifying_glass.png"

diameter = 80

pygame.init()
screen = pygame.display.set_mode((512,256),0,32)
background = pygame.image.load(background_imgfile)
magview = pygame.Surface((256,256))


class MagSprite(pygame.sprite.Sprite):

    def __init__(self   ):
        pygame.sprite.Sprite.__init__(self)
        self.image = pygame.image.load(sprite_imgfile)
        self.rect = self.image.get_rect()

    def update(self):
        (mx,my) = pygame.mouse.get_pos()
        self.rect.center = (mx,my)
        print(mx, my)
        if (mx+diameter/2 < 256) and (my+diameter/2 < 256) and (mx-diameter/2 > 0) and (my-diameter/2 >0):
            magview = background.subsurface((mx-diameter/2,my-diameter/2,diameter,diameter)).copy()
            magview = pygame.transform.scale(magview,(256,256))
            screen.blit(magview,(256,0))


mSprite = MagSprite()
allsprites = pygame.sprite.Group()
allsprites.add(mSprite)

while True:
    for event in pygame.event.get():
        if event.type == QUIT:
            exit()
        screen.blit(background,(0,0))
        allsprites.update()
        allsprites.draw(screen)
        pygame.display.update()
