#include "GameScene.h"
#include "cocostudio/CocoStudio.h"
#include "ui/CocosGUI.h"

USING_NS_CC;

using namespace cocostudio::timeline;

Scene* GameScene::createScene()
{
    // 'scene' is an autorelease object
    auto scene = Scene::create();
    
    // 'layer' is an autorelease object
    auto layer = GameScene::create();

    // add layer as a child to scene
    scene->addChild(layer);

    // return the scene
    return scene;
}

// on "init" you need to initialize your instance
bool GameScene::init()
{
    if ( !Layer::init() )
    {
        return false;
    }
    
	Size visibleSize = Director::getInstance()->getVisibleSize();
	Vec2 origin = Director::getInstance()->getVisibleOrigin();

	auto background = Sprite::create("menu.png");
	background->setPosition(Point(visibleSize.width / 2 + origin.x, visibleSize.height / 2 + origin.y));

	this->addChild(background);

	//Snippet 3-0
	auto sprite = Sprite::create("play.png");
	sprite->setPosition(Point(visibleSize.width / 2 + origin.x, visibleSize.height / 2 + origin.y));

	this->addChild(sprite);

	//Snippet 3-1
	auto moveBy = MoveBy::create(2, Vec2(300, 0));
	auto moveTo = MoveTo::create(2, Vec2(300, 500));
	auto rotateTo = RotateTo::create(2.0f, 45.0f);

	//Comment out next two lines when inserting Snippet 3-2
	//sprite->runAction(moveBy);
	//sprite->runAction(rotateTo);

	//Snippet 3-2
	auto spawn = Spawn::createWithTwoActions(moveTo, rotateTo);
	auto delay = DelayTime::create(1);
	auto seq1 = Sequence::create(moveBy, delay, spawn, nullptr);

	//Comment out next line when inserting Snippet 3-3
	//sprite->runAction(seq1);
	
	//Snippet 3-3
	auto move_ease_in = EaseBounceIn::create(moveBy->clone());
	auto seq2 = Sequence::create(move_ease_in, delay, spawn, nullptr);
	auto spawn2 = Spawn::createWithTwoActions(seq1, seq2);
    sprite->runAction(RepeatForever::create(spawn2));

    return true;
}
