#include "MainMenuScene.h"
#include "GameScene.h"
#include "Definitions.h"
#include "cocostudio/CocoStudio.h"
#include "ui/CocosGUI.h"

USING_NS_CC;

using namespace cocostudio::timeline;

Scene* MainMenuScene::createScene()
{
    // 'scene' is an autorelease object
    auto scene = Scene::create();
    
    // 'layer' is an autorelease object
    auto layer = MainMenuScene::create();

    // add layer as a child to scene
    scene->addChild(layer);

    // return the scene
    return scene;
}

// on "init" you need to initialize your instance
bool MainMenuScene::init()
{
    if ( !Layer::init() )
    {
        return false;
    }
    
	Size visibleSize = Director::getInstance()->getVisibleSize();
	Vec2 origin = Director::getInstance()->getVisibleOrigin();

	auto background = Sprite::create("menu.png");
	background->setPosition(Point(visibleSize.width / 2 + origin.x, visibleSize.height / 2 + origin.y));

	this->addChild(background);

	//Snippet 2-0
	auto playButton = MenuItemImage::create("play.png", "play_clicked.png", CC_CALLBACK_1(MainMenuScene::goToGameScene, this));
	playButton->setPosition(Point(visibleSize.width / 2 + origin.x, visibleSize.height / 2 + origin.y));
    
	auto menu = Menu::create(playButton, NULL);
	menu->setPosition(Point::ZERO);

	this->addChild(menu);

	return true;
}

void MainMenuScene::goToGameScene(cocos2d::Ref *sender) {
	auto scene = GameScene::createScene();

	Director::getInstance()->replaceScene(scene);
}
