import pygame
from pygame.locals import *
from sys import exit
import math

class Vector(object): 
    def __init__(self, x=0.0, y=0.0): 
        self.x = x 
        self.y = y
        
    def __str__(self): 
        return "(%s, %s)"%(self.x, self.y)
    
    def get_magnitude(self): 
        return math.sqrt(self.x**2 + self.y**2)
        
    def normalize(self): 
        magnitude = self.get_magnitude() 
        self.x /= magnitude 
        self.y /= magnitude 
    
    @classmethod
    def vector_from_points(cls,from_p,to_p): 
        return cls(to_p[0]-from_p[0],to_p[1]-from_p[1])
        
mpos = (0.0,0.0)
destination = (200.0,0.0)
player_image = 'head.jpg'


pygame.init()

screen = pygame.display.set_mode((640, 640), 0, 32)
pygame.display.set_caption("Animate X!")


mouse_cursor = pygame.image.load(player_image).convert_alpha()

clock = pygame.time.Clock()

speed = 300.0
heading = Vector.vector_from_points(mpos, destination) 
heading.normalize()

while True:
    for event in pygame.event.get():
        if event.type == QUIT:
            exit()
    screen.fill((255,255,255))
    
    time_passed = clock.tick() / 1000.0
    moved_distance = time_passed * speed

    
    screen.blit(mouse_cursor,mpos)
    mpos= (mpos[0]+heading.x * moved_distance,mpos[1] + heading.y * moved_distance)

    pygame.display.update()
