import pygame
from pygame.locals import *
from sys import exit
from math import *

class Vector(object): 
    def __init__(self, x=0.0, y=0.0): 
        self.x = x 
        self.y = y
        
    def __str__(self): 
        return "(%s, %s)"%(self.x, self.y)
    
    def get_magnitude(self): 
        return sqrt(self.x**2 + self.y**2)
        
    def normalize(self): 
        magnitude = self.get_magnitude() 
        self.x /= magnitude 
        self.y /= magnitude 
    
    @classmethod
    def vector_from_points(cls,from_p,to_p): 
        return cls(to_p[0]-from_p[0],to_p[1]-from_p[1])
        
mpos = (300.0,300.0)
player_image = 'head.jpg'

pygame.init()

screen = pygame.display.set_mode((640, 640), 0, 32)
pygame.display.set_caption("Animate X!")


mouse_cursor = pygame.image.load(player_image).convert_alpha()

clock = pygame.time.Clock()

speed = 300.0
sprite_rotation = 0. 
sprite_rotation_speed = 360.0

while True:
    for event in pygame.event.get():
        if event.type == QUIT:
            exit()
            
    pressed_keys = pygame.key.get_pressed() 
    rotation_direction = 0. 
    movement_direction = 0. 
    if pressed_keys[K_LEFT]: 
        rotation_direction = +1.0 
    if pressed_keys[K_RIGHT]: 
        rotation_direction = -1.0
    if pressed_keys[K_UP]: 
        movement_direction = +1.0 
    if pressed_keys[K_DOWN]: 
        movement_direction = -1.0 

    
    screen.fill((255,255,255))
    
    rotated_sprite = pygame.transform.rotate(mouse_cursor, sprite_rotation) 
    w, h = rotated_sprite.get_size() 
    sprite_draw_pos = (mpos[0]-w/2, mpos[1]-h/2) 
    screen.blit(rotated_sprite, sprite_draw_pos) 
    
    time_passed = clock.tick() / 1000.0
    
    sprite_rotation += rotation_direction * sprite_rotation_speed * time_passed 
    
    heading_x = sin(sprite_rotation*pi/180.0) 
    heading_y = cos(sprite_rotation*pi/180.0) 
    heading = Vector(movement_direction*heading_x,movement_direction*heading_y) 
    moved_distance = time_passed * speed
    mpos= (mpos[0]+heading.x * moved_distance,mpos[1] + heading.y * moved_distance)
    #mpos= heading * speed * time_passed 


    pygame.display.update()
