#pragma once
#ifndef __GAMELAYER_H__
#define __GAMELAYER_H__

#define GOAL_WIDTH 400

#include "Box2D.h"
#include "GameSprite.h"
#include "extensions/cocos-ext.h"
#include "Box2dTest.h"
#include "GLES-Render.h"
#include "cocos2d.h"


class GameLayer : public cocos2d::Layer

{

	b2World *_world;
	b2Body *_staticBody;
	b2Body *_dynamicBody;
	GameSprite* _ball;
	GameSprite* _box;
	GameSprite* _ground;

	Size _screenSize;
	Vec2 _center;
	Vec2 _delta;
	float32 _timeStep;

	GLESDebugDraw * _debugDraw;
	
	

public:
	GameLayer();
	virtual ~GameLayer();
	virtual bool init();

	static cocos2d::Scene* scene();

	CREATE_FUNC(GameLayer);

	void onTouchesBegan(const std::vector<Touch*> &touches, cocos2d::Event* event);
	void onTouchesMoved(const std::vector<Touch*> &touches, cocos2d::Event* event);
	void onTouchesEnded(const std::vector<Touch*> &touches, cocos2d::Event* event);

	
	
	
private:
	void initPhysics();
	void update(float dt);

	void createDynamicBox(float xPos, float yPos, float width, float height);
	void createBoxes();

protected:
	virtual void draw(cocos2d::Renderer *renderer, const cocos2d::Mat4& transform, uint32_t flags) override;

};


#endif //__GAMELAYER_H__

