import pygame
from pygame.locals import *
from player import *

pygame.init()


screen_width = 400
screen_height = 200

screen = pygame.display.set_mode((screen_width, screen_height), 0, 32)
pygame.display.set_caption("Bounce")
ball1 = Ball((100,200),(10,400))
ball2 = Ball((20,20),(40,100),color=(40,200,40))
ball3 = Ball((40,20),(300,200),speed=350,color=(40,40,255))
ball4 = Ball((200,40),(300,200),color=(255,40,255))

ballsprites = pygame.sprite.RenderUpdates()
ballsprites.add(ball1)
ballsprites.add(ball2)
ballsprites.add(ball3)
ballsprites.add(ball4)

background = pygame.Surface((screen_width,screen_height))
background.fill((255,255,255))
screen.blit(background,(0,0))
pygame.display.update()

clock = pygame.time.Clock()
while True:
    for event in pygame.event.get():
        if event.type == QUIT:
            exit()

    time_passed = clock.tick() / 1000.0

    ballsprites.update(time_passed, (screen_width, screen_height))
    rects = ballsprites.draw(screen)
    pygame.display.update(rects)
    ballsprites.clear(screen, background)
