
__author__="Alexander De Luca"

import pygame
import math
import vector # my own vector class

class Ball(pygame.sprite.Sprite):

    def __init__(self,player_position, destination=(0,0),speed=300,size=20,color=(255,10,10)):
        pygame.sprite.Sprite.__init__(self)
        
        self.angle = 0.0 # angle of the surface
        self.speed = speed # pixels per second
        self.pos = player_position # center position of the sprite
        self.destination = destination
        self.bounce = -1

        self.image = pygame.Surface((size,size),pygame.SRCALPHA,32)
        pygame.draw.circle(self.image,color,(size/2,size/2),size/2)
        
        self.rect = self.image.get_rect()
        self.rect.center = player_position
        self.heading = vector.Vector.vector_from_points(self.rect.center, destination)
        self.heading.normalize()

    def update(self,time_passed,screen_size):
        moved_distance = time_passed * self.speed
        move_x = self.heading.x * moved_distance
        move_y = self.heading.y * moved_distance


        self.pos = (self.pos[0]+move_x,self.pos[1] + move_y)

        # test if the player is still within the screen
        # not the best solution though
        new_x = self.pos[0]
        new_y = self.pos[1]
        if self.pos[0] + self.rect.width/2 > screen_size[0]:
            new_x = screen_size[0] - self.rect.width/2
            self.heading.x *= self.bounce
        if self.pos[0] - self.rect.width/2 < 0:
            new_x = 0 + self.rect.width/2
            self.heading.x *= self.bounce
        if self.pos[1] + self.rect.height/2 > screen_size[1]:
            new_y = screen_size[1] - self.rect.height/2
            self.heading.y *= self.bounce
        if self.pos[1] - self.rect.height/2 < 0:
            new_y = 0 + self.rect.width/2
            self.heading.y *= self.bounce
        self.pos = (new_x,new_y)
        self.rect.center = self.pos

    """caculates where and how to move the player"""
    def move_to(self,destination):
        self.destination = destination
        self.heading = vector.Vector.vector_from_points(self.rect.center, destination)
        self.heading.normalize()
        