package medientechnik.ue02;

import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.*;
import javafx.stage.Stage;

public class Yaca extends Application {
    public void start(Stage primaryStage) throws Exception {
        int padding = 5;
        double fieldWidth = 50;

        BorderPane root = new BorderPane();
        FlowPane topRow = new FlowPane();
        FlowPane bottomRow = new FlowPane();

        TextField firstNumberField = new TextField();
        TextField secondNumberField = new TextField();

        Label equalsLabel = new Label("=");

        ObservableList<String> operators = FXCollections.observableArrayList("+", "-", "*", "/");

        ComboBox<String> operatorBox = new ComboBox<String>(operators);

        Button calculateButton = new Button("Calculate!");
        Button resetButton = new Button("Clear");

        TextField resultField = new TextField();


        firstNumberField.setPrefWidth(fieldWidth);
        secondNumberField.setPrefWidth(fieldWidth);

        firstNumberField.setText("0");
        secondNumberField.setText("0");

        resultField.setEditable(false);


        // instead of showing an empty value in the dropdown
        // we select the first entry (at index 0);
        operatorBox.getSelectionModel().select(0);

        topRow.setAlignment(Pos.CENTER);
        bottomRow.setAlignment(Pos.CENTER);
        topRow.setHgap(padding);
        topRow.setVgap(padding);
        topRow.getChildren().addAll(firstNumberField,
                operatorBox,
                secondNumberField,
                equalsLabel,
                resultField);

        bottomRow.setHgap(padding);
        bottomRow.setVgap(padding);
        bottomRow.getChildren().addAll(
                calculateButton,
                resetButton
        );

        BorderPane.setMargin(bottomRow, new Insets(padding,0,padding,0));
        root.setPadding(new Insets(padding));
        root.setTop(topRow);
        root.setBottom(bottomRow);


        Scene scene = new Scene(root);
        primaryStage.setScene(scene);
        primaryStage.sizeToScene();
        primaryStage.setTitle("Yet another Calculator! (YacaView)");
        primaryStage.show();
    }
}
