package de.lmu.mmi2.exercise5;

import java.util.ArrayList;

import org.mt4j.MTApplication;
import org.mt4j.input.inputProcessors.componentProcessors.unistrokeProcessor.UnistrokeUtils.UnistrokeGesture;
import org.mt4j.util.MT4jSettings;
import org.mt4j.util.math.Vector3D;

public class GestureExercise extends MTApplication{
	private static final long serialVersionUID = 1L;
	private CreateTemplateScene templateCreatorScene = null; 
	
	//ArrayList for holding the touch points that make up the custom gestures
	private ArrayList<Vector3D> gesture1 = null;
	private ArrayList<Vector3D> gesture2 = null;
	private ArrayList<Vector3D> gesture3 = null;
	
	public static void main(String[] args) {
		MT4jSettings.fullscreen = true;
		initialize();
	}
	
	@Override
	public void startUp() {
		// uncomment the following line if you have multitouch apple trackpad
		// getInputManager().registerInputSource(new MacTrackpadSource(this));
		
		//Start with one scene or the other not the two of them at the same time
		
		// Create the template creator scene
		templateCreatorScene = new CreateTemplateScene(this, "Template creator");
		addScene(templateCreatorScene);

		// OR
		
		// Create the basic ImageScene
		//addImageScene();
	}

	public void setGesturesPoints(ArrayList<Vector3D> points, int gestureId) {
		switch (gestureId) {
		case 1: 
			gesture1 = points; 
			break;
		case 2: 
			gesture2 = points; 
			break;
		case 3: 
		default:
			gesture3 = points; 
			break;
		}
			
	}
	
	public void addImageScene() {
		ImageScene imageScene = new ImageScene(this, "Multitouch Images");
		
		// we add the gestures we create to the known templates
		imageScene.initGestureProcessors();
		imageScene.addGestureToProcessor(gesture1, UnistrokeGesture.REMOVE);
		imageScene.addGestureToProcessor(gesture2, UnistrokeGesture.MAXIMIZE);
		imageScene.addGestureToProcessor(gesture3, UnistrokeGesture.MINIMIZE);
		
		// If we have two scene, we need to handle the transition 
		// from one to the next
		if (templateCreatorScene !=null) {
			// we store the old scene, because  
			// we can't destroy it until another one is active
			this.pushScene();
			templateCreatorScene.shutDown();
		}
		
		// We add the new Drag and Drop scene to the application
		addScene(imageScene);
		
		if (templateCreatorScene !=null) {
			// Now that we added the old scene  
			// we don't need the old one anymore
			this.changeScene(imageScene);
			templateCreatorScene.destroy();
		}
	}

}
